import { supabase, TABLES } from '@/config/supabase';
import { generateFromLLM } from './openai';
import {
  buildReminderPrompt,
  buildGreetingPrompt,
  buildShoppingAssistPrompt,
  buildPriceInsightPrompt,
  buildGeneralAssistantPrompt
} from './prompts';

export const aiService = {
  async generateReminder(vendorId: string, { name, occasion, style }: { name: string; occasion: string; style?: string }) {
    // Optionally fetch vendor context from Supabase
    // const { data: vendor } = await supabase.from(TABLES.VENDORS).select('*').eq('id', vendorId).single();
    const prompt = buildReminderPrompt(name, occasion, style);
    const message = await generateFromLLM(prompt);
    return { message };
  },

  async generateGreeting(vendorId: string, { name, context, style }: { name: string; context?: string; style?: string }) {
    const prompt = buildGreetingPrompt(name, context, style);
    const message = await generateFromLLM(prompt);
    return { message };
  },

  async generateShoppingAssist(vendorId: string, { items, context }: { items: string[]; context?: string }) {
    const prompt = buildShoppingAssistPrompt(items, context);
    const message = await generateFromLLM(prompt);
    return { message };
  },

  async generatePriceInsight(vendorId: string, { item, market, trend }: { item: string; market: string; trend: string }) {
    const prompt = buildPriceInsightPrompt(item, market, trend);
    const message = await generateFromLLM(prompt);
    return { message };
  },

  async generalAssistant(vendorId: string, { prompt, context }: { prompt: string; context?: string }) {
    const fullPrompt = buildGeneralAssistantPrompt(prompt, context);
    const message = await generateFromLLM(fullPrompt);
    return { message };
  }
}; 